#include <iostream>
#include <vector>
#include <algorithm>
#include <unordered_set>

using namespace std;

int main() {
    int n, k;
    cin >> n >> k;

    vector<int> x(k);
    for (int& xi : x) {
        cin >> xi;
    }

    vector<int> p(n);
    for (int& pi : p) {
        cin >> pi;
    }

    unordered_set<int> existingStores(x.begin(), x.end());

    long long totalCustomers = 0;
    for (int customers : p) {
        totalCustomers += customers;
    }

    vector<pair<int, int>> cityCustomers;
    for (int i = 0; i < n; ++i) {
        cityCustomers.push_back({p[i], i + 1});
    }

    sort(cityCustomers.begin(), cityCustomers.end(), greater<pair<int, int>>());

    long long requiredCustomers = totalCustomers / 2 + 1;
    long long accumulatedCustomers = 0;
    int storesNeeded = 0;

    for (auto& city : cityCustomers) {
        int cityIndex = city.second;
        if (existingStores.find(cityIndex) != existingStores.end()) {
            accumulatedCustomers += city.first;
        } else if (accumulatedCustomers < requiredCustomers) {
            accumulatedCustomers += city.first;
            storesNeeded++;
        }

        if (accumulatedCustomers >= requiredCustomers) {
            break;
        }
    }

    cout << storesNeeded << endl;

    return 0;
}